TITLE   'Anisotropic Conduction in Wood'			{ exa143.pde }
SELECT     errlim=1e-4     ngrid=1     spectral_colors  	
VARIABLES   temp				
DEFINITIONS
   L=0.1     w=0.001     kx=0.14     ky=0.35     heat=0		{ Pine }
   fluxd_x=-kx*dx(temp)     fluxd_y=-ky*dy(temp)
   fluxd=vector( fluxd_x, fluxd_y)     fluxd_m=magnitude( fluxd)
EQUATIONS
   dx[-kx*dx(temp)]+ dy[-ky*dy(temp)]=heat
BOUNDARIES
region 'domain'  start 'outer' (-L,-L) value(temp)=273   line to (L,-L)
   natural(temp)=0  line to (L,L)  to (w,L)
   natural(temp)=-1000  line to (-w,L)				{ Heater flux }
   natural(temp)=0 line to (-L,L) close
PLOTS
   contour( temp)     surface( temp)
   contour( temp) painted zoom(-0.1*L,0.8*L,  0.2*L,0.2*L)
   vector( fluxd) norm	
END


